/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingCanBeHiredFrom;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.colony.jobs.JobArcherTraining;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingArchery
extends AbstractBuildingWorker {
    private static final String SCHEMATIC_NAME = "archery";
    private static final String DESC = "archery";
    private final List<BlockPos> shootingStands = new ArrayList<BlockPos>();
    private final List<BlockPos> shootingTargets = new ArrayList<BlockPos>();

    public BuildingArchery(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobArcherTraining(citizen);
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (super.assignCitizen(citizen) && citizen != null) {
            IBuilding building = citizen.getHomeBuilding();
            if (building != null && !building.getID().equals((Object)this.getID())) {
                building.removeCitizen(citizen);
            }
            citizen.setHomeBuilding(this);
            return true;
        }
        return false;
    }

    @Override
    public void removeCitizen(ICitizenData citizen) {
        if (this.isCitizenAssigned(citizen)) {
            citizen.setHomeBuilding(null);
        }
        super.removeCitizen(citizen);
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if (block == Blocks.field_235396_nb_) {
            this.shootingTargets.add(pos);
        } else if (block == Blocks.field_150426_aN) {
            this.shootingStands.add(pos);
        }
        super.registerBlockPosition(block, pos, world);
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.shootingTargets.clear();
        this.shootingStands.clear();
        ListNBT targetList = compound.func_150295_c("archeryTargets", 10);
        this.shootingTargets.addAll(NBTUtils.streamCompound(targetList).map(targetCompound -> BlockPosUtil.read(targetCompound, "target")).collect(Collectors.toList()));
        ListNBT standTagList = compound.func_150295_c("archeryStands", 10);
        this.shootingStands.addAll(NBTUtils.streamCompound(standTagList).map(targetCompound -> BlockPosUtil.read(targetCompound, "stand")).collect(Collectors.toList()));
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT targetList = this.shootingTargets.stream().map(target -> BlockPosUtil.write(new CompoundNBT(), "target", target)).collect(NBTUtils.toListNBT());
        compound.func_218657_a("archeryTargets", (INBT)targetList);
        ListNBT standTagList = this.shootingStands.stream().map(target -> BlockPosUtil.write(new CompoundNBT(), "stand", target)).collect(NBTUtils.toListNBT());
        compound.func_218657_a("archeryStands", (INBT)standTagList);
        return compound;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return "archery";
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getJobName() {
        return "archer";
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Agility;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Adaptability;
    }

    @Override
    public int getMaxInhabitants() {
        return this.getBuildingLevel();
    }

    public BlockPos getRandomShootingStandPosition(Random random) {
        if (!this.shootingStands.isEmpty()) {
            return this.shootingStands.get(random.nextInt(this.shootingStands.size()));
        }
        return null;
    }

    public BlockPos getRandomShootingTarget(Random random) {
        if (!this.shootingTargets.isEmpty()) {
            return this.shootingTargets.get(random.nextInt(this.shootingTargets.size()));
        }
        return null;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.archery;
    }

    public static class View
    extends AbstractBuildingWorkerView
    implements IBuildingCanBeHiredFrom {
        public View(IColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerModulePlaceholder<View>(this, "archery");
        }

        @Override
        public boolean hasEnoughWorkers() {
            return this.getWorkerId().size() >= this.getBuildingLevel();
        }
    }
}

